package gov.va.med.mhv.rxrefill.data.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "MEDICATION_HISTORIES")
public class MedicationHistory implements Serializable {

	private static final long serialVersionUID = -989471761263391884L;

	@Id
	@Column(name = "MEDICATION_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long medicationId;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "COMMENTS")
	private String comments;

	@Column(name = "REASON_FOR_TAKING")
	private String reason;
	
	@Column(name = "START_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date startDate;
	
	@Column(name = "STRENGTH")
	private String strength;
	
	@Column(name = "PHARMACY_PHONE_NBR")
	private String pharmacyPhone;

	@Column(name = "DOSAGE")
	private String dosage;
	
	@Column(name = "FREQUENCY")
	private String frequency;
	
	@Column(name = "MEDICATION_CATEGORY")
	private String category;
	
	@Column(name = "PRESCRIPTION_NBR")
	private String prescriptionNumber;
	
	@Column(name = "END_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date endDate;
	
	@Column(name = "MEDICATION_NAME")
	private String medicationName;
	
	@Column(name = "PHARMACY_NAME")
	private String pharmacyName;
	
	@Column(name = "USER_PROFILE_USER_PROFILE_ID")
	private Long userId;
	
	/*@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "USER_PROFILE_USER_PROFILE_ID")
	private UserProfile userProfile;*/
	
	public Long getMedicationId() {
		return medicationId;
	}

	public void setMedicationId(Long medicationId) {
		this.medicationId = medicationId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public String getStrength() {
		return strength;
	}

	public void setStrength(String strength) {
		this.strength = strength;
	}

	public String getPharmacyPhone() {
		return pharmacyPhone;
	}

	public void setPharmacyPhone(String pharmacyPhone) {
		this.pharmacyPhone = pharmacyPhone;
	}

	public String getDosage() {
		return dosage;
	}

	public void setDosage(String dosage) {
		this.dosage = dosage;
	}

	public String getFrequency() {
		return frequency;
	}

	public void setFrequency(String frequency) {
		this.frequency = frequency;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getPrescriptionNumber() {
		return prescriptionNumber;
	}

	public void setPrescriptionNumber(String prescriptionNumber) {
		this.prescriptionNumber = prescriptionNumber;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getMedicationName() {
		return medicationName;
	}

	public void setMedicationName(String medicationName) {
		this.medicationName = medicationName;
	}

	public String getPharmacyName() {
		return pharmacyName;
	}

	public void setPharmacyName(String pharmacyName) {
		this.pharmacyName = pharmacyName;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	/*public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}*/
}
